/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class EnglishWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADVERBS = new HashSet<String>();

    public EnglishWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong("Moreover, the street is almost entirely residential. <marker>Moreover</marker>, it was named after a poet."), Example.fixed("Moreover, the street is almost entirely residential. <marker>It</marker> was named after a poet."));
    }

    @Override
    public String getId() {
        return "ENGLISH_WORD_REPEAT_BEGINNING_RULE";
    }

    @Override
    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return ADVERBS.contains(token.getToken());
    }

    static {
        ADVERBS.add("Additionally");
        ADVERBS.add("Besides");
        ADVERBS.add("Furthermore");
        ADVERBS.add("Moreover");
    }
}

